' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox.
' Polska edycja: Wydawnictwo Helion.
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com.  
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

Imports System.Data

Partial Class Management_Appointments
    Inherits System.Web.UI.Page

  Private Sub LoadData()
    Dim dsAppointments As DataSet
    If Not calAppointmentDate.SelectedDate = DateTime.MinValue Then
      dsAppointments = AppointmentManager.GetAppointmentList(calAppointmentDate.SelectedDate)
      repBookingObjects.DataSource = dsAppointments.Tables("BookingObject").DefaultView
      repBookingObjects.DataBind()
      If repBookingObjects.Items.Count = 0 Then
        lblNoRecords.Visible = True
      End If
    End If
  End Sub

  Protected Sub repBookingObjects_ItemDataBound(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.RepeaterItemEventArgs) Handles repBookingObjects.ItemDataBound
    Dim item As RepeaterItem = e.Item
    If item.ItemType = ListItemType.Item Or item.ItemType = ListItemType.AlternatingItem Then
      Dim repAppointments As Repeater = item.FindControl("repAppointments")
      Dim myDataRowView As DataRowView = CType(item.DataItem, DataRowView)
      repAppointments.DataSource = myDataRowView.CreateChildView("BookingObjectAppointment")
      repAppointments.DataBind()
    End If
  End Sub

  Protected Sub calAppointmentDate_SelectionChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles calAppointmentDate.SelectionChanged
    lblSelectedDate.Visible = True
    lblSelectedDate.Text = "Wybrae: <strong>" & calAppointmentDate.SelectedDate.ToShortDateString() & "</strong>"
    lblInstructions.Text = "&nbsp;&nbsp;&nbsp;Kliknij ponownie ikon kalendarza, aby wybrac inn dat:"
    LoadData()
  End Sub

End Class
